import pandas as pd
import json
import pandas as pd
import glob
import os
import ast
def convert_to_nested_format(df,dataset="none"):
    data_list = []

    for i, row in df.iterrows():
        # 构造 origin_data
        origin = {
            "data_source": dataset if dataset != "none" else row["data_source"],
            "source_id": str(row["id"]),
            "question": row["query"],
            "image": row["img_path"],
            "golden_answer": row["possible_answers"] if isinstance(row["possible_answers"], list) else [row["possible_answers"]],
            "program": row["original_code"],
            "program_answer": row["original_result"],
            "static analysis": {
                "difficulty": "easy",
                "extend_method": None,
                "sample_diversity": None,
            }
        }
        expasion_index=row.get("expansion_index", "null")
        if not  isinstance(expasion_index, dict):
            extend_method = None
        else:
            extend_method="depth"  if expasion_index["depth_coef"] > expasion_index["width_coef"] else "width"
        # 构造 extend_data
        extend = {
            "question": row.get("followup_question", ""),
            "image": row["img_path"],
            "program": row.get("followup_code", ""),
            "program_answer": row.get("followup_result", ""),
            "static analysis": {
                "difficulty": "easy",
                "extend_method": extend_method,  # 默认给 depth
                "sample_diversity": "QI",
            }
        }

        # 合并成一个样本
        sample = {
            "origin_data": origin,
            "extend_data_1": extend  # 如有更多 follow-up 可继续添加 extend_data_2
        }

        data_list.append(sample)

    return {"data": data_list}
