#!/bin/bash
#    --warmup_step 300 \
#    --max_epoch   10 \
#    --max_step 2000 \
#    --com_interval 5 \
#    --com_rounds 400 \

lr=1e-3
#lr=8e-4
epochs=5
#export CUDA_VISIBLE_DEVICES="0, 1, 2, 3"
#export CUDA_VISIBLE_DEVICES="4, 5, 6, 7"
WORKERS=8
NUM_GPUS=8
i=0
function rand(){
    min=$1
    max=$(($2-$min+1))
    num=$(($RANDOM+1000000000))
    echo $(($num%$max+$min))
}
port_num=$(rand 49152 65535)
# Execute command
while [ $i -lt $NUM_GPUS ]; do
  python src/gpt2_ft.py \
    --method ours \
    --data_name webnlg_challenge_2017\
    --train_data ./data/webnlg_challenge_2017/train.jsonl \
    --test_data ./data/webnlg_challenge_2017/test.jsonl \
    --output_pred_file eval/GenerationEval/data/hypothesis_webnlg_new \
    --output_ref_file eval/GenerationEval/data/references_webnlg_new \
    --train_batch_size 4 \
    --heterogeneity 1 \
    --eval_ratio 0.0 \
    --grad_acc 1 \
    --valid_batch_size 4 \
    --seq_len 512 \
    --model_card gpt2.md \
    --init_checkpoint ./pretrained_checkpoints/gpt2-medium-pytorch_model.bin \
    --platform local \
    --lamb 0.0005 \
    --rank_max 12 \
    --rank_min 6 \
    --clip 0.0 \
    --lr $lr \
    --lr_in 1e-3 \
    --weight_decay 0.01 \
    --correct_bias \
    --adam_beta2 0.999 \
    --scheduler linear \
    --warmup_step 200 \
    --max_epoch   11 \
    --max_step 20 \
    --com_interval 1 \
    --com_rounds 20 \
    --save_interval 1000 \
    --lora_dim 4 \
    --lora_alpha 32 \
    --lora_dropout 0.1 \
    --label_smooth 0.1 \
    --work_dir ./trained_models/GPT2_M/e2e \
    --random_seed 0 \
    --world_size $WORKERS \
    --rank $i  \
    --port $port_num \
    --beam 10 \
    --length_penalty 0.8 \
    --no_repeat_ngram_size 4 \
    --repetition_penalty 1.0 \
    --eos_token_id 628 \
    --work_dir ./trained_models/GPT2_M/e2e \
    --output_file predict.26289.b10p08r4.jsonl \
    --python \
    --tokenize --lower\
    --ref_type webnlg \
    --ref_num 6 &
  pids="${pids} $!"
  i=$(($i + 1))
done

echo "children:${pids}"
wait
