#!/bin/bash

# Experiment configuration
exp_name=deberta_lora_$task
lr=2e-3
epochs=2
export CUDA_VISIBLE_DEVICES="0, 1, 2, 3"
#export CUDA_VISIBLE_DEVICES="4, 5, 6, 7"
WORKERS=1
NUM_GPUS=1
i=0
function rand(){
    min=$1
    max=$(($2-$min+1))
    num=$(($RANDOM+1000000000))
    echo $(($num%$max+$min))
}
port_num=$(rand 49152 65535)
# Execute command
while [ $i -lt $NUM_GPUS ]; do
  python train_dist.py \
    --name_or_path  microsoft/deberta-v3-base\
    --world_size $WORKERS\
    --dataset squad_v2 \
    --seed 0 \
    --method pf2lora\
    --lr_A 1e-2 \
    --lr_B $lr\
    --rank_mat 4 \
    --rank_max 16 \
    --rank_min 12 \
    --fp16 \
    --beta 0.0 \
    --gamma 0.99 \
    --lamb 0.001 \
    --num_epochs $epochs \
    --port  $port_num\
    --batch_size 16\
    --eval_batch_size 8\
    --com_interval 10 \
    --heterogeneity 0.5 \
    --num_gpu $NUM_GPUS \
    --gpu $i \
    --rank $i \
    --com_rounds 200\
    --inner_loops 1\
    --hessian_q 3 \
    --z_loops 5  &
  pids="${pids} $!"
  i=$(($i + 1))
done

echo "children:${pids}"
wait
