# TimeBridge: Bridging Non-stationarity and Dependency Modeling for Long-term Time Series Forecasting

## Prerequisites

Ensure you are using Python 3.9 and install the necessary dependencies by running:

```python
pip install -r requirements.txt
```

## Prepare Datastes

Begin by downloading the required datasets. All datasets are conveniently available at [Autoformer](https://drive.google.com/drive/folders/1ZOYpTUa82_jCcxIdTmyr0LXQfvaM9vIy). Create a separate folder named `./dataset` and neatly organize all the csv files as shown below:

```
dataset
└── electricity.csv
└── ETTh1.csv
└── ETTh2.csv
└── ETTm1.csv
└── ETTm2.csv
└── traffic.csv
└── weather.csv
└── solar_AL.txt
```

##  Training

All scripts are located in `./scripts`. For instance, to train a model using the electricity dataset, simply run:

```
sh ./scripts/Electricity/TimeBridge.sh
```

After training:

- Your trained model will be safely stored in `./checkpoints`.
- Visualization outputs are available in `./test_results`.
- Numerical results in .npy format can be found in `./results`.
- A comprehensive summary of quantitative metrics is accessible in `./results.txt`.
