export CUDA_VISIBLE_DEVICES=2

if [ ! -d "./logs" ]; then
    mkdir ./logs
fi

if [ ! -d "./logs/LongForecasting" ]; then
    mkdir ./logs/LongForecasting
fi

model_name=TSformer
data_name=electricity
seq_len=720


for pred_len in 96, 192, 336, 720
do
  python -u run.py \
    --is_training 1 \
    --root_path ./dataset/ \
    --data_path electricity.csv \
    --model_id electricity_$seq_len_$pred_len \
    --model $model_name \
    --data custom \
    --features M \
    --seq_len $seq_len \
    --label_len 48 \
    --pred_len $pred_len \
    --t_layers 2 \
    --e_layers 2 \
    --enc_in 321 \
    --dec_in 321 \
    --c_in 321 \
    --c_out 321 \
    --des 'Exp' \
    --d_model 512 \
    --d_ff 512 \
    --num_p 12 \
    --learning_rate 0.0005 \
    --batch_size 16 \
    --train_epochs 10 \
    --patience 10 \
    --period 30 \
    --itr 1 >logs/LongForecasting/$data_name'_'$seq_len'_'$model_name'_'$pred_len.log
done
