export CUDA_VISIBLE_DEVICES=2

if [ ! -d "./logs" ]; then
    mkdir ./logs
fi

if [ ! -d "./logs/LongForecasting" ]; then
    mkdir ./logs/LongForecasting
fi

model_name=TSformer
data_name=weather
seq_len=720


for pred_len in 96, 192, 336, 720
do
  python -u run.py \
    --is_training 1 \
    --root_path ./dataset/ \
    --data_path weather.csv \
    --model_id weather_$seq_len_$pred_len \
    --model $model_name \
    --data custom \
    --features M \
    --seq_len $seq_len \
    --label_len 48 \
    --pred_len $pred_len \
    --t_layers 1 \
    --e_layers 2 \
    --enc_in 21 \
    --dec_in 21 \
    --c_in 21 \
    --c_out 21 \
    --des 'Exp' \
    --d_model 128 \
    --d_ff 128 \
    --num_p 4 \
    --learning_rate 0.0001 \
    --batch_size 32 \
    --train_epochs 10 \
    --patience 10 \
    --period 30 \
    --itr 1 >logs/LongForecasting/$data_name'_'$seq_len'_'$model_name'_'$pred_len.log
done
