export CUDA_VISIBLE_DEVICES=3

if [ ! -d "./logs" ]; then
    mkdir ./logs
fi

if [ ! -d "./logs/LongForecasting" ]; then
    mkdir ./logs/LongForecasting
fi

model_name=TSformer
data_name=solar
seq_len=720


for pred_len in 96, 192, 336, 720
do
  python -u run.py \
    --is_training 1 \
    --root_path ./dataset/ \
    --data_path solar_AL.txt \
    --model_id solar_$seq_len_$pred_len \
    --model $model_name \
    --data Solar \
    --features M \
    --seq_len $seq_len \
    --label_len 48 \
    --pred_len $pred_len \
    --t_layers 1 \
    --e_layers 2 \
    --enc_in 137 \
    --dec_in 137 \
    --c_in 137 \
    --c_out 137 \
    --des 'Exp' \
    --d_model 128 \
    --d_ff 128 \
    --num_p 12 \
    --learning_rate 0.0005 \
    --batch_size 32 \
    --train_epochs 10 \
    --patience 10 \
    --period 30 \
    --itr 1 >logs/LongForecasting/$data_name'_'$seq_len'_'$model_name'_'$pred_len.log
done
