from Base import *
import numpy as np

np.random.seed(100)

n_layers = 5
input_dim = 4
output_dim = 1
n_units = 4

# generate net

total_results = []
def run():
  ta = task(input_dim = input_dim, output_dim = output_dim, n_layers = n_layers, n_units = n_units)
  ta.init_param(sigma = 0.5)
  ta.set_true()

  # so = [deepcopy(ta) for i in range(n_layers)]

  so = []
  so_copy = []
  for i in range(n_layers):
    so.append(task(input_dim = input_dim, output_dim = n_units,
                    n_layers = i+1, n_units = n_units))
    so[i].init_param()
    so[i].set_representation(ta, n_rep = i+1)
    so[i].set_true()
    so[i].init_param()
    so_copy.append(deepcopy(so[i]))

  ta.init_param() # set random before training
  ta_copy = deepcopy(ta)
  results = [0]*(n_layers) + [0]
  dat_so = []
  for i in range(n_layers):
    dat_so.append(so[i].gen_data(1000, sigma = 0.5))
  dat_ta = ta.gen_data(100, sigma = 0.5)
  for i in range(n_layers):
    #ta = deepcopy(ta_copy)
    so[i].init_param()
    #so[i] = deepcopy(so_copy[i])
    so[i].training(dat_so[i])
    # so[i].net = so[i].net_true
    ta.set_representation(so[i], n_rep = i+1)
    results[i] += ta.training(dat_ta, with_rep = True)

  ta = deepcopy(ta_copy)
  results[-1] += ta.training(dat_ta, with_rep = False)
  return(results)

from joblib import Parallel, delayed
total_results = Parallel(n_jobs=5)(delayed(run)() for _ in range(100))  # n_jobs = number of processes
print(np.mean(total_results, 0))
print(np.std(total_results, 0))
