# In-Context Policy Evaluation Convergence

This repository contains the code used in our experiments on the convergence of in-context TD and MC.

## 📦 Environment Setup

We use [Conda](https://docs.conda.io/en/latest/) for package management.

1. Run the following script to create a local virtual environment in `./.env` and install all dependencies:

    ```bash
    bash setup.sh
    ```

2. Activate the environment:

    ```bash
    conda activate ./.env
    ```

> ℹ️ The environment is fully self-contained and project-local; no global changes are made to your system.

---

## 🚀 Running Experiments

1. To verify that the environment and code are working correctly, run a quick test:

    ```bash
    python main.py --test
    ```

2. To reproduce all experiment results reported in the paper:

    ```bash
    bash run.sh
    ```

3. Outputs including weights, metrics, and figures will be saved to:

    ```
    ./log/
    ```