#!/bin/bash
#SBATCH --job-name=train
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=5
#SBATCH --gres=gpu:tesla_v100-pcie-32gb:1
#SBATCH --time=1-00:00:00
#SBATCH --output=train_imdb.out
#SBATCH --error=train_imdb.err

srun python train.py experiment='trans-vanilla-lra-imdb' >> train_imdb.out 2>> train_imdb.err
srun python train.py experiment='trans-linformer-lra-imdb' >> train_imdb.out 2>> train_imdb.err
srun python train.py experiment='trans-performer-lra-imdb' >> train_imdb.out 2>> train_imdb.err
srun python train.py experiment='trans-reformer-lra-imdb' >> train_imdb.out 2>> train_imdb.err
srun python train.py experiment='trans-bigbird-lra-imdb' >> train_imdb.out 2>> train_imdb.err
srun python train.py experiment='trans-cosformer-lra-imdb' >> train_imdb.out 2>> train_imdb.err
srun python train.py experiment='s4-lra-imdb' >> train_imdb.out 2>> train_imdb.err
srun python train.py experiment='gtu-lra-imdb' >> train_imdb.out 2>> train_imdb.err