
# CMIRA: Class Membership Inducing Recovery Attacks Against Machine Unlearning Models

![Alt text](assets/bar.png)

<div align="center">

 [:sparkles: Overview](#sparkles-overview) | [:computer: Usage](#computer-usage) | [:link: Cite](#link-cite) | [:heart: Acknowledgement](#heart-acknowledgement) | [:scroll: License](#scroll-license)

<div align="left">

## :sparkles: Overview

Figure 1 is the demonstration of recovery attack against MU models, which is critical and prospective to study the vulnerability of current MU-based privacy preservation.

</div>
<table align="center">
  <tr>
    <td align="center"> 
      <img src="./assets/motivation.png" alt="Image 1" style="width: 700px;"/> 
      <br>
      <em style="font-size: 18px;">  <strong style="font-size: 18px;">Figure 1: </strong> Demonstration of recovery attack against MU models.</em>
    </td>
  </tr>
</table>

<div align="left">


To implement CMIRA, which works as shown in Figure 2, firstly we create a probing dataset $\mathcal{D}_p: \mathcal{X}_p\mapsto\mathcal{Y}_p$ that is similar to $\mathcal{D}_f$. Note that $\mathcal{D}_p$ can be easily created by finding similar images and their labels through image search engines given the query images $\mathcal{X}_f$. In particular, we design a mutual knowledge distillation approach in which the attack model $\mathcal{M}_{A}$ can iteratively recover the plausible knowledge, i.e, $ \mathcal{X}_f\mapsto\mathcal{\hat{Y}}_f$, by inducing the unlearned model $\mathcal{M}_{U}$ to recover the class memberships of $\mathcal{X}_f$ with the knowledge distilled from $\mathcal{D}_p$.


</div>
<table align="center">
  <tr>
    <td align="center"> 
      <img src="./assets/arch.png" alt="Image 1" style="width: 700px;"/> 
      <br>
      <em style="font-size: 18px;">  <strong style="font-size: 18px;">Figure 2: </strong> The framework of model training, unlearning and recovery attack: (a) The workflow to obtain MU models; (b) The implementation of CMIRA scheme.</em>
    </td>
  </tr>
</table>

<div align="left">

## :computer: Usage

### :rainbow: Environment

```bashs
conda env create -f environment.yml
```

### :fire: Train

#### :zap: Train Backbone Model

```bash
sh scripts/step-00-machine-unlearning-prep.sh
```

#### :zap: Train Unlearning Model

```bash
sh scripts/step-01-machine-unlearning.sh
```

#### :zap: Save models and data for unlearning

```bash
sh scripts/step-02-save_dasaveta.sh
```

#### :zap: Train Lipschitz model

```bash
cd nets
sh step-03-train_lipnet.sh
```

#### :zap: Fine tunning Lipschitz model

```bash
cd nets
sh step-04-finetune_unlearn.sh
```

For ablation study, you can run the following scripts to train the models.

```bash
cd nets
sh scripts/step-04-finetune_unlearn_ablation_study
```

#### :zap: Save models and data for fine tunning

```bash
# on the root directory
sh scripts/step-05-save_ft_data.sh
```

### :hammer: Check results

```bash
# cd your data directory
tree $DATA_DIR

# cd your model directory
tree $MODEL_DIR
```

### :bar_chart: Evaluation

```bash
cd data_process
python load_acc.py
```

```bash
cd data_process
python load_lip_acc.py
```

```bash
cd data_process
python save_predicts_embedding.py # save the prediction and embedding
```

### :rocket: Analysis

> **_NOTE:_**  The analysis code is not available for the public temporarily. If you need the code, please contact me.

Email: Under anonymity consider hiding temporarily. It will be available after the review process.

### :file_folder: Download

If you can't reproduce the results, you can connect me to get the trained models and data.
Email: Under anonymity consider hiding temporarily. It will be available after the review process.

## :link: Cite

If you find this repository useful for your research, please consider citing the following paper:

```bibtex
@article{???cmira,
  title={CMIRA: Class Membership Inducing Recovery Attacks Against Machine Unlearning Models},
  author={Under anonymity consider hiding temporarily.},
  journal={Under anonymity consider hiding temporarily.},
  year={2025}
}
```

## :heart: Acknowledgement

Under anonymity consider hiding temporarily. It will be available after the review process.

## :scroll: License

This repository respects to MIT license.
