# Massive Multi-Task Learning (MMTL)
The primary purpose of the MMTL package is to enable flexible prototyping and experimentation in what we call the massive multi-task learning setting, where we have large numbers of tasks and labels of varying types, granularities, and label accuracies. 
A major requirement of this regime is the ability to easily add or remove new datasets, new label sets, new tasks, and new metrics. Thus, in the MMTL package, each of these concepts have been decoupled.

## Blog Posts
For more discussion around the motivation for MMTL, check out our blog posts:
* [Massive Multi-Task Learning with Snorkel MeTaL: Bringing More Supervision to Bear](https://dawn.cs.stanford.edu/2019/03/22/glue/)
* [Emerging Topics in Multi-Task Learning Systems](https://hazyresearch.github.io/snorkel/blog/mtl_systems.html)

## Tutorials
For hands-on experience using the MMTL package, check out our tutorials:
* The [MMTL_Basics](https://github.com/HazyResearch/metal/blob/master/tutorials/MMTL_Basics.ipynb) tutorial is the best place to start for an overview of the basic classes in the MMTL package.
* Additional tutorials are planned for future minor version updates to Snorkel MeTaL.
