close all
clear all

counter_one = h5read('random_seq_width_one.h5', '/counter');
counter_two = h5read('random_seq_width_two.h5', '/counter');


figure('Position', [100 100 2000 800]);


bar(100:100:1000,[counter_one(1:10); counter_two(1:10)]); 

% plot(err_u_1(1:100), 'LineWidth', 5, 'Color', 'k'); hold on;
% plot(err_v_1(1:100), 'LineWidth', 5, 'Color', 'b')


set(gca,'FontSize', 30)
xlabel('$M$', 'FontSize', 50, 'interpreter','latex');




% legend('First layer fixed', ...
%     'Both layers learned', 'FontSize', 25, 'interpreter','latex','Location','northwest')
legend('Learning only $\mathbf{V}$', ...
    'Learning $\mathbf{U}$ and $\mathbf{V}$', 'FontSize', 25, 'interpreter','latex','Location','northwest')

% set(gcf,'position',[100,100,500,300])

% axis([0 150 0 110])
% axis([0 100 0 10])
% pbaspect([1.5 1. 1])

% set(gcf,'OuterPosition',[50 50 700 500]);
% ax = gca;
% outerpos = ax.OuterPosition;
% ti = ax.TightInset; 
% left = outerpos(1) + ti(1);
% bottom = outerpos(2) + ti(2) + 0.05;
% ax_width = outerpos(3) - ti(1) - ti(3);
% ax_height = outerpos(4) - ti(2) - ti(4) - 0.05;
% ax.Position = [left bottom ax_width ax_height];

addpath ./export_fig/
export_fig -pdf -transparent bar_M.pdf
% export_fig -pdf -transparent train_err_mnist.pdf