clear all
close all


% a = figure('Position', [100 100 600 450]);
% b = axes(a,"Units","pixels","Position",[50 100 500 300])
% 
% err_tanh_sgd  = h5read('silhouette_tanh_sgd.h5', '/e');
% err_tanh_adam = h5read('silhouette_tanh_adam.h5', '/e');
% err_bin = h5read('silhouette_bin.h5', '/e');
err_tanh_sgd  = h5read('mnist_tanh_sgd.h5', '/e');
err_tanh_adam = h5read('mnist_tanh_adam.h5', '/e');
err_bin = h5read('mnist_bin.h5', '/e');

% err_u = h5read('silhouette_200_two.h5', '/err_u');
% err_v = h5read('silhouette_200_two.h5', '/err_v');

figure;
% plot(err_u(1:100), 'LineWidth', 5, 'Color', 'k'); hold on;
% plot(err_v(1:100), 'LineWidth', 5, 'Color', 'b')

% plot(err_u(1:100), 'LineWidth', 5, 'Color', 'k'); hold on;
% plot(err_v(1:100), 'LineWidth', 5, 'Color', 'b')

plot(err_bin, 'LineWidth', 5, 'Color', 'b'); hold on;
plot(err_tanh_sgd(1:200), 'LineWidth', 5, 'Color', 'k'); 
plot(err_tanh_adam(1:200), 'LineWidth', 5, 'Color', 'r'); hold on;


xlabel('epoch', 'FontSize', 15, 'interpreter','latex');
set(gca,'FontSize', 25)

legend('Ours', ...
    'tanh, SGD', 'tanh, Adam','FontSize', 25, 'interpreter','latex')

% set(gcf,'position',[100,100,500,300])

% axis([0 100 0 100])
% axis([0 100 0 40])
% pbaspect([1.5 1. 1])

set(gcf,'OuterPosition',[50 50 700 600]);
ax = gca;
outerpos = ax.OuterPosition;
ti = ax.TightInset; 
left = outerpos(1) + ti(1);
bottom = outerpos(2) + ti(2) + 0.05;
ax_width = outerpos(3) - ti(1) - ti(3);
ax_height = outerpos(4) - ti(2) - ti(4) - 0.05;
ax.Position = [left bottom ax_width ax_height];

addpath ../export_fig/
% export_fig -pdf -transparent train_tanh_silhouette.pdf
export_fig -pdf -transparent train_tanh_mnist.pdf