clear all
close all

N = 100; M = 200; T = 100;
err1 = zeros(20,T);
err2 = zeros(20,T);

for i = 1:20
    M = i*100;
    for t = 1:T
        x = sign(randn(N,1));
%         P = randn(M,N);
        P = 2*rand(M,N) - 1;
        W = pinv(P);

        err1(i,t) = sum(sum(abs(x - sign(W*sign(P*x)))));
        err2(i,t) = sum(sum(abs(x - sign(P'*sign(P*x)))));
    end
    i
end

figure('Position', [100 100 600 400]);

plot(100:100:2000,mean(err1,2), 'LineWidth', 5, 'Color', 'k'); hold on;
plot(100:100:2000,mean(err2,2), 'LineWidth', 5, 'Color', 'b')

xlabel('$M$', 'FontSize', 15, 'interpreter','latex');
set(gca,'FontSize', 25)


legend('$\mathbf{V}=\mathbf{P}^+$', ...
    '$\mathbf{V}=\mathbf{P}^{\top}$', 'FontSize', 25, 'interpreter','latex','Location','northeast')

set(gca,'LooseInset',get(gca,'TightInset'))

addpath ../export_fig/
export_fig -pdf -transparent rand_perm_uniform.pdf