clear all
close all

% rng(0)
 
X = h5read('mnist_test_seq.h5','/data');
X = X(:,:,1:20,:);
% size(X)
 
X = 2*single(sign(X(1:end,1:end,:,:))) - 1;

T = 20;
K = 64;
N = K^2;

U = h5read('mnist_bin.h5', '/U')';
V = h5read('mnist_bin.h5', '/V')';
U = h5read('mnist_tanh.h5', '/U')';
V = h5read('mnist_tanh.h5', '/V')';

s = 11;
Y = zeros(N,T);
Y(:,1) = reshape(X(:,:,s,1),[N 1]);

rand_idx = randperm(N);
for i = 1:500
    Y(rand_idx(i),1) = -Y(rand_idx(i),1);
end

for t = 1:T-1
    h        = sign(U*Y(:,t));
    Y(:,t+1) = sign(V*h);
end

figure('Position',[100 100 1200 400]);

colormap(gray)
for t = 1:T
    subplot(1,2,1),imagesc(X(:,:,s,t)', [-1 1]); 
    axis equal; axis off;
    subplot(1,2,2),imagesc(reshape(Y(:,t), [K K])', [-1 1]); 
    axis equal; axis off;
    pause(0.2)
end

addpath export_fig/
figure;
colormap(gray)
for t = 1:T
    imagesc(X(:,:,s,t)', [-1 1]); 
    axis equal; axis off;
    fname = sprintf('seq_%d_%d_gt.pdf', s, t);
%     export_fig(fname,  '-pdf')
end
% 
figure;
colormap(gray)
for t = 1:T
    imagesc(reshape(Y(:,t), [K K])', [-1 1]); 
    axis equal; axis off;
    fname = sprintf('seq_%d_%d_two.pdf', s, t);
%     export_fig(fname,  '-pdf')
end
