clear all
close all

T = 136 - 34 + 1;
N = 128*88;
M = 200;

epochs = 100;

X = single(zeros(N,T));

for i = 34:136
    I = imread(sprintf('OULP_SilhouetteSample/%08d.png', i));        
    X(:,i-34+1) = 2*sign(single(reshape(I,[N 1]))) - 1;
end

U = h5read('silhouette_tanh_adam.h5', '/U')';
V = h5read('silhouette_tanh_adam.h5', '/V')';

% U = h5read('silhouette_bin.h5', '/U')';
% V = h5read('silhouette_bin.h5', '/V')';


Y = single(zeros(N,T));
Y(:,1) = X(:,1);
Z(:,1) = X(:,1);


rp = randperm(N);
for i = 1:2000
    Y(rp(i),1) = -Y(rp(i),1);
end

for t = 1:T-1   
%     h        = sign(U*Y(:,t));
%     Y(:,t+1) = sign(V*h);   

    h        = tanh(U*Y(:,t));
    Y(:,t+1) = tanh(V*h);   

    Z(:,t+1) = X(:,t+1);
end

norm(Y-Z)
% figure;
% colormap(gray)
% for t = 1:T
%     I = reshape(Y(:,t), [128 88]);
%     imagesc(I);
%     axis off;
%     axis equal;
% 
%     pause(0.5)
% end
% 
% addpath export_fig/
% figure;
% colormap(gray)
% for t = 1:10
%     imagesc(reshape(X(:,t), [128 88]), [-1 1]); 
%     axis equal; axis off;
%     fname = sprintf('silhouette_%d_gt.pdf', t);
%     export_fig(fname,  '-pdf')
% end
% % 
figure;
colormap(gray)
for t = 1:100
    I = reshape(Y(:,t), [128 88]);
    imagesc(I, [-1 1]); 
    axis equal; axis off;
    fname = sprintf('silhouette_%d_one.pdf', t);
%     export_fig(fname,  '-pdf')
end

% 
% h5create('silhouette_200_two.h5', '/U', size(U), 'Datatype', 'single');
% h5create('silhouette_200_two.h5', '/V', size(V), 'Datatype', 'single');
% h5create('silhouette_200_two.h5', '/err_u', size(err_u));
% h5create('silhouette_200_two.h5', '/err_v', size(err_v));
% h5write('silhouette_200_two.h5', '/U', U);
% h5write('silhouette_200_two.h5', '/V', V);
% h5write('silhouette_200_two.h5', '/err_u', err_u);
% h5write('silhouette_200_two.h5', '/err_v', err_v);