clear all
close all

T = 136 - 34 + 1;
N = 128*88;
M = 200;

epochs = 100;

X = single(zeros(N,T));

for i = 34:136
    I = imread(sprintf('OULP_SilhouetteSample/%08d.png', i));    
    X(:,i-34+1) = 2*sign(single(reshape(I,[N 1]))) - 1;
end

k1 = 1;
k2 = 1;
r1 = 0.00;
r2 = 0.001;

U = 0.001*single(randn(M,N));
V = single(zeros(N,M));

err_u = zeros(1,epochs);
err_v = zeros(1,epochs);

    
for t = 1:T-1
    x1 = X(:,t);
    x2 = X(:,t+1);

    y1 = sign(U*x1);    
    
    V = V + x2 * y1';                
end

Z = single(zeros(N,T));
Y = single(zeros(N,T));
Y(:,1) = X(:,1);
Z(:,1) = X(:,1);

rng(0)

rp = randperm(N);
for i = 1:2000
    Y(rp(i),1) = -Y(rp(i),1);
end

for t = 1:T-1   
    h        = sign(U*Y(:,t));
    Y(:,t+1) = sign(V*h);   
    Z(:,t+1) = X(:,t+1);
end

norm(Y-Z)
% figure;
% colormap(gray)
% for t = 1:T
%     I = reshape(Y(:,t), [128 88]);
%     imagesc(I);
%     axis off;
%     axis equal;
% 
%     pause(0.5)
% end
% 
addpath export_fig/
% figure;
% colormap(gray)
% for t = 1:10
%     imagesc(reshape(X(:,t), [128 88]), [-1 1]); 
%     axis equal; axis off;
%     fname = sprintf('silhouette_%d_gt.pdf', t);
%     export_fig(fname,  '-pdf')
% end
% % 
figure;
colormap(gray)
for t = 3
    imagesc(reshape(Y(:,t), [128 88]), [-1 1]); 
    axis equal; axis off;
    fname = sprintf('silhouette_%d_heb.pdf', t);
    export_fig(fname,  '-pdf')
end

% 
% h5create('silhouette_200_two.h5', '/U', size(U), 'Datatype', 'single');
% h5create('silhouette_200_two.h5', '/V', size(V), 'Datatype', 'single');
% h5create('silhouette_200_two.h5', '/err_u', size(err_u));
% h5create('silhouette_200_two.h5', '/err_v', size(err_v));
% h5write('silhouette_200_two.h5', '/U', U);
% h5write('silhouette_200_two.h5', '/V', V);
% h5write('silhouette_200_two.h5', '/err_u', err_u);
% h5write('silhouette_200_two.h5', '/err_v', err_v);
% 
% h5create('silhouette_200_one.h5', '/U', size(U), 'Datatype', 'single');
% h5create('silhouette_200_one.h5', '/V', size(V), 'Datatype', 'single');
% h5create('silhouette_200_one.h5', '/err_u', size(err_u));
% h5create('silhouette_200_one.h5', '/err_v', size(err_v));
% h5write('silhouette_200_one.h5', '/U', U);
% h5write('silhouette_200_one.h5', '/V', V);
% h5write('silhouette_200_one.h5', '/err_u', err_u);
% h5write('silhouette_200_one.h5', '/err_v', err_v);