

using Statistics, LaTeXStrings
using Plots, NPZ

method = "phys_inf"

ic_data_dir = "/home/adele/sph_learning/analytic_gradient_method/physics_informed_sph_learning"
phys_inf_data_dir = "./basic_physics_informed/output_data_fsa_4p_cabg_KL_s_hit_itr3000_lr0.05_T2_D2_N1024_c12.0_α1.0_β2.0_h0.2_nball_nint90_ts3205"

traj_gt = npzread("$(ic_data_dir)/data/traj_N1024_T6001_ts5801_h0.2_s_hit_cdt0.4_c12.0_α1.0_β2.0_θ0.08_AV_neg_rel_ke.npy")
vels_gt = npzread("$(ic_data_dir)/data/vels_N1024_T6001_ts5801_h0.2_s_hit_cdt0.4_c12.0_α1.0_β2.0_θ0.08_AV_neg_rel_ke.npy")
rhos_gt = npzread("$(ic_data_dir)/data/rhos_N1024_T6001_ts5801_h0.2_s_hit_cdt0.4_c12.0_α1.0_β2.0_θ0.08_AV_neg_rel_ke.npy")

t_start = 3205;
traj_gt = traj_gt[t_start:end, :, :]
vels_gt = vels_gt[t_start:end, :, :]
rhos_gt = rhos_gt[t_start:end, :]


N = size(traj_gt)[2];
D = size(traj_gt)[3];
m = (2. * pi)^D / N; #so that ρ₀ = 1;
θ = 0.8e-1;

c_out = npzread("$(phys_inf_data_dir)/c_out.npy");
α_out = npzread("$(phys_inf_data_dir)/alpha_out.npy");
β_out = npzread("$(phys_inf_data_dir)/beta_out.npy");
g_out = npzread("$(phys_inf_data_dir)/g_out.npy");


c = c_out[end]; α = α_out[end]; β = β_out[end]; g = g_out[end]; h = 0.2;
cdt = 0.4; dt = cdt * h / c;


include("./sph_simulator.jl")

T = 500;
traj, vels, rhos = vel_verlet(traj_gt, vels_gt, α, β, h, c, g, θ, T)



function obtain_tke(vels)
  tke = zeros(T);
  for k in 1 : T
      tke[k] = 0.5*mean(vels[k,:,1].^2 .+ vels[k,:,2].^2)
  end
  return tke
end

tke = obtain_tke(vels)

function compute_Re(vels)
  Re = zeros(T+1)
  V = 0.0
  L = 2*pi
  ν = 1/10 * α * c * h
  for t in 1 : (T+1)
    V = maximum(vels[t, :, :])
    Re[t] = L*V/ν
  end
  return Re
end

Re = compute_Re(vels)

function compute_turb_ke(vels)
	turb_ke = zeros(T);
	for t in 1 : T
		avg_KE = 0.5*mean(vels[t, :, 1].^2 .+ vels[t, :, 2].^2)
		dec_ke = 0.5 * (mean(vels[t, :, 1])^2 + mean(vels[t, :, 2])^2)
		turb_ke[t] = avg_KE - dec_ke
	end
	return turb_ke
end

turb_ke = compute_turb_ke(vels)

#-----outputs
function create_dir(dir_name)
	if isdir(dir_name) == true
	    println("directory already exists")
	else mkdir(dir_name)
	end
end

create_dir("learned_sim_figures"); create_dir("learned_sims");

ENV["GKSwstype"]="100"


#-----------Outputs

sim_path = "./learned_sims/traj_N$(N)_T$(T)_h$(h)_cdt$(cdt)_c$(c)_α$(α)_β$(β)_θ$(θ)_$(method).mp4"
file_out_tke = "./figures/tke_N$(N)_T$(T)_h$(h)_cdt$(cdt)_c$(c)_α$(α)_β$(β)_θ$(θ)_$(method).png"
file_out_re = "./figures/re_N$(N)_T$(T)_h$(h)_cdt$(cdt)_c$(c)_α$(α)_β$(β)_θ$(θ)_$(method).png"
file_out_turb_ke = "./figures/turb_ke_N$(N)_T$(T)_h$(h)_cdt$(cdt)_c$(c)_α$(α)_β$(β)_θ$(θ)_$(method).png"


function plot_KE_fluc()
    gr(size=(500,400))
    println("*************** generating plots ******************")

	plt = plot(turb_ke, label=L"k", color="blue", linewidth = 2.25)
	title!(L"\textrm{Turbulent kinetic energy: } \theta = %$(θ)", titlefont=16)
	xlabel!(L"t", xtickfontsize=10, xguidefontsize=16)
	ylabel!(L"k", ytickfontsize=10, yguidefontsize=16)
    display(plt)
    savefig(plt, file_out_turb_ke)
end


function plotting_Re()
  gr(size=(500,500))
  plt = plot(Re, label=L"Re", color="blue", linewidth = 2.25)
  title!(L"\textrm{Reynolds number: } \theta = %$(θ)", titlefont=16)
  xlabel!(L"t", xtickfontsize=10, xguidefontsize=16)
  ylabel!(L"Re", ytickfontsize=10, yguidefontsize=16)
  display(plt)
  savefig(plt, file_out_re)
end




function simulate(pos, sim_time=10)
    gr(size=(1000,800))
    println("**************** Simulating the particle flow ***************")
    #theme(:juno)
    n_2 = round(Int,N/2)
    anim = @animate for i ∈ 1:2:(T+1)
         Plots.scatter(pos[i, 1:n_2, 1], pos[i, 1:n_2, 2],
         title = "WCSPH_$(method): N=$(N), h=$(h), c=$(c)", xlims = [0, 2*pi], ylims = [0,2*pi], legend = false)
         Plots.scatter!(pos[i, (n_2+1):end, 1], pos[i, (n_2+1):end, 2], color = "red")
    end
    gif(anim, sim_path, fps = round(Int, T/sim_time))
    println("****************  Simulation COMPLETE  *************")
end




plot_KE_fluc()
plotting_Re()
simulate(traj, 10)
# simulate_same_color(traj, 8)
