import pathlib
from typing import Optional

from rau.vocab import VocabularyBuilder, ToStringVocabularyBuilder
from rau.tasks.language_modeling.vocabulary import (
    load_vocabulary_data_from_file,
    build_softmax_vocab
)

def load_output_vocabulary_from_file(
    path: pathlib.Path,
    builder: Optional[VocabularyBuilder]=None
):
    if builder is None:
        builder = ToStringVocabularyBuilder()
    vocabulary_data = load_vocabulary_data_from_file(path)
    return build_softmax_vocab(vocabulary_data.tokens, vocabulary_data.allow_unk, builder)
