# Measuring Scarcity--Complexity Collision in Language Models

This repository accompanies the paper *Measuring Scarcity--Complexity Collision in Language Models*


## Installation

To install the repository, simply run, within a suitable python environment

```bash
pip install -e 
```

We also use `gnu-parallel` to run training on multiple cpu cores 

```bash
# On Ubuntu
sudo apt-get install parallel
```

## Sampling
Sampling requires a cuda enabled GPU, this is due to the expensive backwards weights calculations that have been optimized on the GPU.

## Training
We recommend using CPUs since they can run in parallel, we train a single model in within minutes on a modern CPU core. Note the settings in the bash scripts for how many cores to use.

## Experiments

The expirements rely on a large scale sampling of data, and training of neural lanuage models.
These were run using slurm on a cluster, we have commented out the specific cluster details to maintain anonimity.

We conduct three different types of experiments in the work. To understand the setup, we recommend looking at the parity+free one to start with.

### Parity+Free experiment

Sampling and training scripts are under `./experiments_parityfree_intervention`.

Run `bash experiments_parityfree_intervention/setup.sh` to setup the data, it is currently set to sample a single weight configuration but can be modified to run for 200 like in the paper easily.

For training run `bash experiments_parityfree_intervention/train.sh`, it is also hardcoded to a single machine, with commented out configurations to train multiple machines for observed data and intervened on data. See the commented out lines for `AM_IDX` to up the number of machines, and `MSEED` for how many models to train per configuration---in the paper we use 10.

For plotting the results run `python experiments_parityfree_intervention/plot.py`.

### Large scale expectation 

Here we sample many machines with 50 states and 10 symbols.
The same general comments as above apply for these experiments. See `sample.sh`, `train.sh` and `plot.py` in `./experiments_random_100_10`. Note that the sampling script is a slurm script.

### Comparison between states

Here we sample a single unweighted configuration with 40 states, and then sample multiple weight configurations.
Same here, see the scripts `sample.sh`, `train.sh` and `plot.py` in `./experiments_random_final`.