set -euo pipefail

. intervention_sampling/functions.bash

usage() {
  echo "Usage: $0 <model-dir> <test-data-dir>

Evaluate a saved neural network.
"
}

model_dir=${1-}
test_data_dir=${2-}
if ! shift 2; then
  usage >&2
  exit 1
fi
extra_args=("$@")

eval_dir=$model_dir/eval
mkdir -p "$eval_dir"
python intervention_sampling/neural_networks/evaluate.py \
  --batching-max-tokens 1024 \
  --load-model "$model_dir" \
  --input-file "$test_data_dir"/main.prepared \
  --output "$eval_dir" \
  "${extra_args[@]}"
