import random
from rayuela.base.symbol import Sym
from rayuela.occ_semiring.utils import get_arcs
from rayuela.base.semiring import Real


def duplicate_symbol_arcs(
    A, tgt_symbol=None, delete_arcs=0
):

    A_p = A.copy()

    if tgt_symbol is None:
        # we pick a random tgt symbol
        symbols = A.Sigma
        tgt_symbol = random.choice(list(symbols))
    
    new_symbol = Sym(f"X")

    arcs = get_arcs(A)
    arcs_w_tgt = [arc for arc in arcs if arc[1] == tgt_symbol]

    for arc in arcs_w_tgt:
        divisor = Real(2)
        A_p.add_arc(arc[0], new_symbol, arc[2], arc[3] / divisor)
        A_p.set_arc(arc[0], tgt_symbol, arc[2], arc[3] / divisor)
    
    if delete_arcs > 0:
        arcs_to_delete = random.sample(arcs_w_tgt, delete_arcs)

        for arc in arcs_to_delete:
            A_p.set_arc(arc[0], tgt_symbol, arc[2], Real(0))

        A_p = A_p.trim()
        A_p = A_p.normalize()    

    return A_p, tgt_symbol, new_symbol.value
