from copy import deepcopy
from typing import Dict

from src.quantizers.kivi_quantizer import KIVIQuantizer
from src.quantizers.base_quantizer import BaseQuantizer
from src.quantizers.kvquant_quantizer import KVQuantQuantizer
from src.quantizers.coupled_quantizer import CoupledQuantizer
from src.quantizers.nsn_quantizer import NSNQuantizer

def get_quantizer(quant_config: Dict, layer_idx: int):
    # Make a copy of config since it is cls variable
    conf = deepcopy(quant_config)
    
    quantizer_classes = {
        "NSNQuantizer": NSNQuantizer,
        "KIVIQuantizer": KIVIQuantizer,
        "Identity": BaseQuantizer,
        "KVQuantQuantizer": KVQuantQuantizer,
        "CoupledQuantizer": CoupledQuantizer,
    }
    quantizer_class = quantizer_classes[conf["name"]]

    if conf["kwargs"]:
        if "layer_idx" in conf["kwargs"].keys():
            conf["kwargs"]["layer_idx"] = layer_idx

        return quantizer_class(**conf["kwargs"])

    else:
        return quantizer_class()
