import numpy as np
import time
import torch
from contextlib import contextmanager

class Recorder:
    def __init__(self):
        self.values = dict()

    def add_value(self, name: str, value: float) -> None:
        if name in self.values:
            self.values[name].append(value)
        else:
            self.values[name] = [value]

    def agg_everything(self) -> None:
        keys = list(self.values.keys())
        for name in keys:
            self.values[f"{name}_len"] = len(self.values[name])
            self.values[name] = np.mean(self.values[name])

    @contextmanager
    def record_time(self, name: str):
        torch.cuda.synchronize()
        start = time.time()
        try:
            yield
        finally:
            torch.cuda.synchronize()
            end = time.time()
            self.add_value(name, end - start)


recorder = Recorder()
