#!/bin/bash
data_dir=data-bin/wmt14_en_de
checkpoint_dir=./ckpt/aw_hmm_4_wmt14_de_en

export CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7

fairseq-train ${data_dir} --source-lang de --target-lang en \
    --user-dir fs_plugins \
    \
    --task translation_lev_modified  --noise full_mask \
    \
    --arch glat_decomposed_link_base --adaptive-neighbor-distance 4 \
    --decoder-learned-pos --encoder-learned-pos \
    --share-all-embeddings --activation-fn gelu \
    --apply-bert-init \
    --links-feature feature:position --decode-strategy lookahead \
    --max-source-positions 150 --max-target-positions 1200 --src-upsample-scale 8.0 \
    \
    --criterion nat_dag_loss --train-mode sum \
    --length-loss-factor 0 --max-transition-length -1 \
    --glat-p 0.5:0.1@200k --glance-strategy number-random \
    \
    --optimizer adam --adam-betas '(0.9,0.999)' --fp16 \
    --label-smoothing 0.0 --weight-decay 0.01 --dropout 0.1 \
    --lr-scheduler inverse_sqrt  --warmup-updates 10000   \
    --clip-norm 0.1 --lr 0.0005 --warmup-init-lr '1e-07' --stop-min-lr '1e-09' \
    --ddp-backend c10d \
    \
    --max-tokens 4096  --update-freq 2 --distributed-world-size 8 --grouped-shuffling \
    --max-update 300000 --max-tokens-valid 4096 \
    --save-interval 1  --save-interval-updates 10000  \
    --seed 0 \
    \
    --valid-subset valid \
    --validate-interval 1       --validate-interval-updates 10000 \
    --eval-bleu --eval-bleu-args '{"iter_decode_max_iter": 0, "iter_decode_with_beam": 1}' \
    --eval-bleu-detok moses --eval-bleu-remove-bpe --eval-bleu-print-samples \
    --fixed-validation-seed 7 \
    --best-checkpoint-metric bleu --maximize-best-checkpoint-metric   \
    --keep-best-checkpoints 5 --keep-last-epochs 10 --save-dir ${checkpoint_dir} \
    --log-format 'simple' --log-interval 100 \
    --torch-dag-best-alignment \
    --torch-dag-loss


# average_checkpoints after training is done
average_checkpoint_path=${checkpoint_dir}/average.pt

python3 ./fs_plugins/scripts/average_checkpoints.py --inputs ${checkpoint_dir} \
          --max-metric --best-checkpoints-metric bleu --num-best-checkpoints-metric 5 \
          --output ${average_checkpoint_path}

echo "-----------------------------------------------------------------------------------"
echo "greedy-----------------------------------------------------------------------------"
echo "-----------------------------------------------------------------------------------"
fairseq-generate ${data_dir} \
    --gen-subset test --user-dir fs_plugins --task translation_lev_modified -s de -t en \
    --iter-decode-max-iter 0 --iter-decode-eos-penalty 0 --beam 1 \
    --remove-bpe --max-tokens 4096 --seed 0 \
    --model-overrides "{\"decode_strategy\":\"greedy\"}" \
    --path ${average_checkpoint_path} --quiet 
echo "-----------------------------------------------------------------------------------"
echo "lookahead--------------------------------------------------------------------------"
echo "-----------------------------------------------------------------------------------"
fairseq-generate ${data_dir} \
    --gen-subset test --user-dir fs_plugins --task translation_lev_modified -s de -t en \
    --iter-decode-max-iter 0 --iter-decode-eos-penalty 0 --beam 1 \
    --remove-bpe --max-tokens 4096 --seed 0 \
    --model-overrides "{\"decode_strategy\":\"lookahead\",\"decode_beta\":1}" \
    --path ${average_checkpoint_path} --quiet 
echo "-----------------------------------------------------------------------------------"
echo "viterbi----------------------------------------------------------------------------"
echo "-----------------------------------------------------------------------------------"
fairseq-generate ${data_dir} \
    --gen-subset test --user-dir fs_plugins --task translation_lev_modified -s de -t en \
    --iter-decode-max-iter 0 --iter-decode-eos-penalty 0 --beam 1 \
    --remove-bpe --max-tokens 4096 --seed 0 \
    --model-overrides "{\"decode_strategy\":\"viterbi\"}" \
    --path ${average_checkpoint_path} --quiet
echo "-----------------------------------------------------------------------------------"
echo "viterbi norm length----------------------------------------------------------------"
echo "-----------------------------------------------------------------------------------"
fairseq-generate ${data_dir} \
    --gen-subset test --user-dir fs_plugins --task translation_lev_modified -s de -t en \
    --iter-decode-max-iter 0 --iter-decode-eos-penalty 0 --beam 1 \
    --remove-bpe --max-tokens 4096 --seed 0 \
    --model-overrides "{\"decode_strategy\":\"viterbi\",\"normalize_length\":1}" \
    --path ${average_checkpoint_path} --quiet

echo "viterbi wo emit, norm length-------------------------------------------------------"
fairseq-generate ${data_dir} \
    --gen-subset test --user-dir fs_plugins --task translation_lev_modified -s de -t en \
    --iter-decode-max-iter 0 --iter-decode-eos-penalty 0 --beam 1 \
    --remove-bpe --max-tokens 4096 --seed 0 \
    --model-overrides "{\"decode_strategy\":\"viterbi\",\"normalize_length\":1,\"viterbi_wo_emit\":1}" \
    --path ${average_checkpoint_path} --quiet
echo "-----------------------------------------------------------------------------------"
echo "viterbi wo emit--------------------------------------------------------------------"
echo "-----------------------------------------------------------------------------------"
fairseq-generate ${data_dir} \
    --gen-subset test --user-dir fs_plugins --task translation_lev_modified -s de -t en \
    --iter-decode-max-iter 0 --iter-decode-eos-penalty 0 --beam 1 \
    --remove-bpe --max-tokens 4096 --seed 0 \
    --model-overrides "{\"decode_strategy\":\"viterbi\",\"viterbi_wo_emit\":1}" \
    --path ${average_checkpoint_path} --quiet

for d in "valid" "test"; do
    for p in $(seq 0 0.1 1.0); do
        echo "-----------------------------------------------------------------------------------"
        echo "On ${data}, viterbi penalty ${p}--------------------------------------------------------------"
        echo "-----------------------------------------------------------------------------------"
        fairseq-generate ${data_dir} \
            --gen-subset ${d} --user-dir fs_plugins --task translation_lev_modified -s de -t en \
            --iter-decode-max-iter 0 --iter-decode-eos-penalty 0 --beam 1 \
            --remove-bpe --max-tokens 4096 --seed 0 \
            --model-overrides "{\"decode_strategy\":\"viterbi\",\"viterbi_penalty\":${p},\"normalize_length\":1}" \
            --path ${average_checkpoint_path} --quiet
done
done

