# Seeking Flat Minima with Mean Teacher on Semi- and Weakly-Supervised Domain Generalization for Object Detection

## Download Data
Please download [PASCAL VOC 2007 and 2012](http://host.robots.ox.ac.uk/pascal/VOC/), [Artistic Image dataset](https://github.com/naoto0804/cross-domain-detection/tree/master), and [Car-Mounted Camera dataset](https://github.com/AmingWu/Single-DGOD) by following their official instructions.

Then, please put the data as follows:
```
data
├──voc07
│     ├──Annotations
│     ├──ImageSets
│     └──JPEGImages
├──voc12
├──clipart
├──comic
├──watercolor
├──daytime_clear
├──daytime_foggy
├──dusk_rainy
├──night_rainy
└──night_sunny
```

## Usage

### Prepare docker container
Build docker image and container:
```
docker build -t mt_dgod ./docker
docker run --name mt_dgod_gpu -d --gpus all --ipc=host -v `pwd`:/ws -it mt_dgod /bin/bash
```

### To reproduce the main results
Enter the docker container:
```
docker exec -it mt_dgod_gpu /bin/bash
```
Run the training script:
```
bash train_art.sh
```
For evaluation, run the test script:
```
bash test.sh
```
You can use other config files in ```configs/pt``` to run the training on other settings.

- - -
This code was implemented based on the official implementation of [Probabilistic Teacher](https://github.com/hikvision-research/ProbabilisticTeacher).