# makesense
Code and analyses for our project on evaluating sense-retrofitted embeddings

## Pre-requisites

This project requires the following dependencies:
- python `>=3.7`
- pytorch `>=1.8` (this may change soon to an earlier version)
- minicons `>=0.1.7`
- transformers `>= 4.4.2` (this may also change)

All of these can be accessed from our virtualenv, `makesense`, which can be created using the following command:
```bash
conda env create -f environment.yml
```

Activate the environment using:
```
conda activate makesense
```

## Reproducing our experiments

Step 1 - Generating Data: `notebooks/Combine SemCor and SemEval.ipynb`

Step 2 - Run Retrofitting using LASeR (adapted from [here](https://github.com/bihani-g/LASeR)):

```sh
python experiments/retrofit_generation.py
```

Step 3 - Run approximation experiments (this creates 585 different models, please change hyperparameters according to your requirements to reduce/increase the total models):

```bash
bash experiments/run_approximations.sh
```

Step 4 - Run analyses!

```bash
# Delta
bash experiments/cosine_wic.py

# USIM Notebooks - experiments/usim_prep/usim_store.ipynb

#  WiC Probing
bash experiments/wic_mlprobing.sh

# WHiC Probing
bash experiments/whic_torch_experiments.sh

```
Step 5 - Generating plots: Please refer to `analysis/MakeSense Analysis Scroll.Rmd`

## License

This code is licensed under an [MIT license](https://github.com/).

## Citing

If you make use of this code, please cite the following:
```
{}
```