#!/bin/bash

declare -a hidden_size=("1024" "2048")
declare -a hidden_layers=("2" "3" "4" "5")
declare -a learning_rate=("1e-3" "1e-4" "1e-5")

echo "Running approximation experiments"

for layer in {0..12}
do
    for hs in ${hidden_size[@]}
    do
        for hl in ${hidden_layers[@]}
        do
            for lr in ${learning_rate[@]}
            do
                python approximation_experiments.py --layer $layer --hidden_layers ${hl} --hidden_size ${hs} --lr ${lr} --savedir NonLinearApproximatorLarge
            done 
        done
    done
done