#!/bin/bash

declare -a hidden_layers=("2" "3" "4" "5")
declare -a learning_rate=("1e-3" "3e-3" "5e-3")

echo "Running approximation experiments"

for layer in {0..12}
do
    for hl in ${hidden_layers[@]}
    do
        for lr in ${learning_rate[@]}
        do
            python approximation_experiments.py --layer $layer --hidden_layers ${hl} --hidden_size 2048 --lr ${lr} --savedir NonLinearApproximatorLarge
        done 
    done
done