#!/bin/bash

declare -a hidden_size=("128" "256")
declare -a hidden_layers=("2" "3" "4")
declare -a learning_rate=("3e-4" "1e-4" "1e-5")

echo "Running WiC experiments without Approximation"

for layer in {0..12}
do
    for hs in ${hidden_size[@]}
    do
        for hl in ${hidden_layers[@]}
        do
            for lr in ${learning_rate[@]}
            do
                python wic_experiments.py --layer $layer --hidden_layers ${hl} --hidden_size ${hs} --lr ${lr} --savedir WiCModelSmall --dropout 0.1
            done 
        done
    done
done