#!/bin/bash

declare -a approximation_modes=("original" "laser")

echo "Running approximation experiments"

for layer in {0..12}
do
    for am in ${approximation_modes[@]}
    do
        echo "Running Probing on ${am} bert"
        python whic_torch_probing.py --layer ${layer} --device cuda:1 --approximation ${am}
    done
done


for layer in {0..12}
do
    for am in ${approximation_modes[@]}
    do
        echo "Running Probing on ${am} bert"
        python whic_torch_directional_probing.py --layer ${layer} --device cuda:1 --approximation ${am}
    done
done