#!/usr/local/bin/python3
from optparse import OptionParser
from time import time

from classifiers.common import read_model_from_disk
from util.categories import categories_list

if __name__ == "__main__":
    parser = OptionParser(usage="usage: %prog [options] arg1 arg2")
    parser.add_option("--load-vec", dest="load_vec", help="load_vec", type="string")
    parser.add_option("--load-clf", dest="load_clf", help="load_clf", type="string")
    parser.add_option("--category", dest="category_id", help="category_id", type="int")
    (options, args) = parser.parse_args()

    clf = read_model_from_disk("models/" + options.load_clf)
    _duration_train = 0

    vect_model = read_model_from_disk("models/" + options.load_vec)
    vectorizer = vect_model['vectorizer']
    del vect_model

    while True:
        user_input = input("Enter the text(type 'exit' to quit the program)?\n")
        if user_input == "":
            continue
        elif user_input == "exit":
            exit(0)
        elif len(user_input) < 20:
            print("Error: Please enter a minimum of 20 characters!")
        else:
            print("Processing...Please wait!")
            x_test = vectorizer.transform([user_input])
            t0 = time()
            predicted_target = clf.predict(x_test)
            duration = time() - t0
            categories_for_id = [i[0] for i in categories_list[options.category_id]]
            country = categories_for_id[predicted_target[0]]
            print("%s (time: %2.fs)" % (country, duration))
