def create_sub_categories(top_cat):
    cat = []
    for lang in top_cat:
        cat.append([lang, [lang]])
    return cat


cat1 = ["Telugu", "Romanian", "Sinhala"]
cat2 = ["German", "Indonesian", "Hindi", "Ukrainian", "Turkish", "Malayalam", "Bulgarian", "French",
        "Portuguese"]
cat3 = ["Arabic", "English", "Korean", "Malay", "Italian", "Hungarian", "Japanese", "Tamil", "Spanish",
        "Chinese", "Vietnamese"]

native = ["English"]
non_native = ["Telugu", "Romanian", "Sinhala", "German", "Indonesian", "Hindi", "Ukrainian", "Turkish",
              "Malayalam", "Bulgarian", "French", "Portuguese", "Arabic", "Korean", "Malay", "Italian",
              "Hungarian", "Japanese", "Tamil", "Spanish", "Chinese", "Vietnamese"]
indo_european = ["French", "Portuguese", "Romanian", "Italian", "Spanish", "German", "English", "Hindi", "Sinhala",
                 "Ukrainian", "Bulgarian"]
dravidian = ["Tamil", "Telugu", "Malayalam"]
indo_aryan = ["Hindi", "Sinhala"]
tamil = ["Tamil"]
sinhala = ["Sinhala"]
non_sinhala = [lang for lang in non_native if lang not in sinhala] + native
non_native_non_sinhala = [lang for lang in non_native if lang not in sinhala]
non_native_non_sinhala_non_tamil = [lang for lang in non_native if lang not in sinhala and lang not in tamil]
non_sinhala_non_tamil = [lang for lang in non_native if lang not in sinhala and lang not in tamil] + native
non_native_indo_european = [lang for lang in non_native if lang in indo_european]
non_native_non_indo_european = [lang for lang in non_native if lang not in indo_european]

non_native_non_indo_european_altaic = ["Japanese", "Korean", "Turkish"]
non_native_non_indo_european_sinotibetan = ["Chinese"]
non_native_non_indo_european_afro = ["Arabic"]
non_native_non_indo_european_dravadian = ["Tamil", "Telugu", "Malayalam"]
non_native_non_indo_european_uralic = ["Hungarian"]
non_native_non_indo_european_austronisian = ["Malay", "Indonesian"]
non_native_non_indo_european_austroasiatic = ["Vietnamese"]

non_native_indo_european_non_indo_aryan_romance = ["French", "Portuguese", "Romanian", "Italian", "Spanish"]
non_native_indo_european_non_indo_aryan_germanic = ["German"]
non_native_indo_european_non_indo_aryan_balto_slavic = ["Ukrainian", "Bulgarian"]

non_native_indo_european_indo_aryan = [lang for lang in non_native if lang in indo_european and lang in indo_aryan]
non_native_indo_european_non_indo_aryan = [lang for lang in non_native if
                                           lang in indo_european and lang not in indo_aryan]
non_native_indo_european_indo_aryan_sinhala = [lang for lang in non_native if
                                               lang in indo_european and lang in indo_aryan and lang in sinhala]
non_native_indo_european_indo_aryan_non_sinhala = [lang for lang in non_native if
                                                   lang in indo_european and lang in indo_aryan and lang not in sinhala]
non_native_dravidian = [lang for lang in non_native if lang in dravidian]
non_native_non_dravidian = [lang for lang in non_native if lang not in dravidian]
non_native_dravidian_tamil = [lang for lang in non_native if lang in dravidian and lang in tamil]
non_native_dravidian_non_tamil = [lang for lang in non_native if lang in dravidian and lang not in tamil]
non_native_non_dravidian_indo_european = [lang for lang in non_native if
                                          lang not in dravidian and lang in indo_european]
non_native_non_dravidian_non_indo_european = [lang for lang in non_native if
                                              lang not in dravidian and lang not in indo_european]
non_native_non_dravidian_indo_european_indo_aryan = [lang for lang in non_native if
                                                     lang not in dravidian and lang in indo_european and lang in indo_aryan]
non_native_non_dravidian_indo_european_non_indo_aryan = [lang for lang in non_native if
                                                         lang not in dravidian and lang in indo_european and lang not in indo_aryan]
non_native_non_dravidian_indo_european_indo_aryan_sinhala = [lang for lang in non_native if
                                                             lang not in dravidian and lang in indo_european and lang in indo_aryan and lang in sinhala]
non_native_non_dravidian_indo_european_indo_aryan_non_sinhala = [lang for lang in non_native if
                                                                 lang not in dravidian and lang in indo_european and lang in indo_aryan and lang not in sinhala]

ice_all = ["Canada", "HongKong", "India", "Ireland", "Jamaica", "Nigeria", "Philippines", "Singapore", "SriLanka",
           "USA"]

inner_circle = ["Canada", "USA", "Ireland"]
outer_circle = ["SriLanka", "India", "Philippines", "Nigeria", "Singapore"]
expanded_circle = ["HongKong", "Jamaica"]
asia = ["SriLanka", "India", "Philippines", "HongKong", "Singapore"]
non_asia = ["Ireland", "Nigeria", "Canada", "USA", "Jamaica"]
south_asia = ["SriLanka", "India"]
non_south_asia = [lang for lang in asia if lang not in south_asia]
europe = ["Ireland"]
africa = ["Nigeria"]
north_america = ["Canada", "USA", "Jamaica"]
non_srilanka = [lang for lang in ice_all if lang != "SriLanka"]

categories_list = [
    create_sub_categories(cat1 + cat2 + cat3),  # 0

    [["native", native], ["non_native", non_native]],  # 1

    [["non_native_indo_european", non_native_indo_european],  # 2
     ["non_native_non_indo_european", non_native_non_indo_european]],

    [["non_native_non_indo_european_altaic", non_native_non_indo_european_altaic],
     ["non_native_non_indo_european_sinotibetan", non_native_non_indo_european_sinotibetan],
     ["non_native_non_indo_european_afro", non_native_non_indo_european_afro],
     ["non_native_non_indo_european_dravadian", non_native_non_indo_european_dravadian],
     ["non_native_non_indo_european_uralic", non_native_non_indo_european_uralic],
     ["non_native_non_indo_european_austronisian", non_native_non_indo_european_austronisian],
     ["non_native_non_indo_european_austroasiatic", non_native_non_indo_european_austroasiatic]],  # 3

    create_sub_categories(non_native_non_indo_european_altaic),  # 4

    create_sub_categories(non_native_non_indo_european_dravadian),  # 5

    create_sub_categories(non_native_non_indo_european_austronisian),  # 6

    [["non_native_indo_european_indo_aryan", non_native_indo_european_indo_aryan],  # 7
     ["non_native_indo_european_non_indo_aryan", non_native_indo_european_non_indo_aryan]],

    [["non_native_indo_european_non_indo_aryan_romance", non_native_indo_european_non_indo_aryan_romance],
     ["non_native_indo_european_non_indo_aryan_germanic", non_native_indo_european_non_indo_aryan_germanic],
     ["non_native_indo_european_non_indo_aryan_balto_slavic", non_native_indo_european_non_indo_aryan_balto_slavic]],
    # 8

    create_sub_categories(non_native_indo_european_non_indo_aryan_romance),  # 9

    create_sub_categories(non_native_indo_european_non_indo_aryan_balto_slavic),  # 10

    [["non_native_indo_european_indo_aryan_sinhala", non_native_indo_european_indo_aryan_sinhala],  # 11
     ["non_native_indo_european_indo_aryan_non_sinhala", non_native_indo_european_indo_aryan_non_sinhala]],

    ### ICE CORPUS
    create_sub_categories(ice_all), # 12

    [["native", inner_circle],
     ["non_native", outer_circle + expanded_circle]], # 13

    create_sub_categories(inner_circle),  # 14

    [["outer_circle", outer_circle],
     ["expanded_circle", expanded_circle]], # 15

    create_sub_categories(outer_circle),  # 16

    create_sub_categories(expanded_circle),  # 17

    [["asia", asia],
     ["non_asia", non_asia]], # 18

    [["south_asia", south_asia], ["non_south_asia", non_south_asia]], # 19

    create_sub_categories(south_asia), # 20

    create_sub_categories(non_south_asia), # 21

    [["europe", europe],
     ["africa", africa],
     ["north_america", north_america]], # 22

    create_sub_categories(north_america), # 23

    [["sinhala", sinhala],  # 24
     ["non_sinhala", non_sinhala]],

    [["srilanka", ["SriLanka"]],  # 25
     ["non_srilanka", non_srilanka]],

    create_sub_categories(["Sinhala", "Hindi", "Telugu", "Malayalam", "Tamil", "Malay"]), #26

    create_sub_categories(non_native),  # 27

    create_sub_categories(["Sinhala", "English"]), #28

    create_sub_categories(["Sinhala", "Hindi"]), #29

    [["SriLanka", ["SriLanka"]],["native", inner_circle]], #30

    create_sub_categories(["SriLanka", "India"]) #31
]

cat1 = ["Telugu", "Romanian", "Sinhala"]
cat2 = ["German", "Indonesian", "Hindi", "Ukrainian", "Turkish", "Malayalam", "Bulgarian", "French",
        "Portuguese"]
cat3 = ["Arabic", "English", "Korean", "Malay", "Italian", "Hungarian", "Japanese", "Tamil", "Spanish",
        "Chinese", "Vietnamese"]

# [["non_native_non_dravidian_indo_european", non_native_non_dravidian_indo_european],  # 6
#  ["non_native_non_dravidian_non_indo_european", non_native_non_dravidian_non_indo_european]],
#
# [["non_native_non_dravidian_indo_european_indo_aryan", non_native_non_dravidian_indo_european_indo_aryan],  # 7
#  ["non_native_non_dravidian_indo_european_non_indo_aryan",
#   non_native_non_dravidian_indo_european_non_indo_aryan]],
#
# [["non_native_non_dravidian_indo_european_indo_aryan_sinhala",  # 8
#   non_native_non_dravidian_indo_european_indo_aryan_sinhala],
#  ["non_native_non_dravidian_indo_european_indo_aryan_non_sinhala",
#   non_native_non_dravidian_indo_european_indo_aryan_non_sinhala]],
#
# [["native", native],
#  ["non_native_indo_european_indo_aryan_sinhala", non_native_indo_european_indo_aryan_sinhala],  # 9
#  ["non_native_indo_european_indo_aryan_non_sinhala", non_native_indo_european_indo_aryan_non_sinhala],
#  ["non_native_indo_european_non_indo_aryan", non_native_indo_european_non_indo_aryan],
#  ["non_native_non_indo_european", non_native_non_indo_european]],
#
# [["native", native],  # 10
#  ["non_native_dravidian_tamil", non_native_dravidian_tamil],
#  ["non_native_dravidian_non_tamil", non_native_dravidian_non_tamil],
#  ["non_native_non_dravidian_indo_european_indo_aryan_sinhala",
#   non_native_non_dravidian_indo_european_indo_aryan_sinhala],
#  ["non_native_non_dravidian_indo_european_indo_aryan_non_sinhala",
#   non_native_non_dravidian_indo_european_indo_aryan_non_sinhala],
#  ["non_native_non_dravidian_indo_european_non_indo_aryan",
#   non_native_non_dravidian_indo_european_non_indo_aryan],
#  ["non_native_non_dravidian_non_indo_european", non_native_non_dravidian_non_indo_european]],
#
# [["native", native],  # 11
#  ["sinhala", sinhala],
#  ["non_native_non_sinhala", non_native_non_sinhala]],
#
# [["native", native],  # 12
#  ["sinhala", sinhala],
#  ["tamil", tamil],
#  ["non_native_non_sinhala", non_native_non_sinhala_non_tamil]],
#
# [["sinhala", sinhala],  # 13
#  ["non_sinhala", non_sinhala]],
#
# [["sinhala", sinhala],  # 14
#  ["tamil", tamil],
#  ["non_sinhala_non_tamil", non_sinhala_non_tamil]],
#
# [["native", native],  # 15
#  ["sinhala", sinhala]],
