import datetime
import os

import matplotlib.pyplot as plt
import numpy as np
from sklearn.model_selection import learning_curve


def plot_learning_curve(estimator, title, X, y, ylim=None, cv=None, train_sizes=np.linspace(.1, 1.0, 5), category=None):
    plt.figure(figsize=(10, 30))
    plt.subplot(3, 1, 1)
    train_sizes, train_scores, test_scores, fit_times, _ = learning_curve(estimator, X, y, cv=cv, n_jobs=-1, train_sizes=train_sizes, return_times=True)
    train_scores_mean = np.mean(train_scores, axis=1)
    train_scores_std = np.std(train_scores, axis=1)
    test_scores_mean = np.mean(test_scores, axis=1)
    test_scores_std = np.std(test_scores, axis=1)
    fit_times_mean = np.mean(fit_times, axis=1)
    fit_times_std = np.std(fit_times, axis=1)

    plt.fill_between(train_sizes, train_scores_mean - train_scores_std,
                     train_scores_mean + train_scores_std, alpha=0.1,color="r")
    plt.fill_between(train_sizes, test_scores_mean - test_scores_std,
                     test_scores_mean + test_scores_std, alpha=0.1, color="g")
    plt.plot(train_sizes, train_scores_mean, 'o-', color="r",
             label="Training score")
    plt.plot(train_sizes, test_scores_mean, 'o-', color="g",
             label="Cross-validation score")

    plt.xlabel("Training examples")
    plt.ylabel("Score")
    plt.legend(loc="best")
    plt.grid("on")
    # if ylim:
    plt.ylim(0)
    plt.title(title)

    plt.subplot(3, 1, 2)
    plt.plot(train_sizes, fit_times_mean, 'o-')
    plt.fill_between(train_sizes, fit_times_mean - fit_times_std,
                         fit_times_mean + fit_times_std, alpha=0.1)
    plt.xlabel("Training examples")
    plt.ylabel("fit_times")
    plt.title("Scalability of the model")

    plt.subplot(3, 1, 3)
    plt.plot(fit_times_mean, test_scores_mean, 'o-')
    plt.fill_between(fit_times_mean, test_scores_mean - test_scores_std,
                     test_scores_mean + test_scores_std, alpha=0.1)
    plt.xlabel("fit_times")
    plt.ylabel("Score")
    plt.title("Performance of the model")

    if category is not None:
        plt.savefig("images/" + str(category) + "_plot_learning_curve_" + datetime.datetime.now().strftime(
            '%s') + ".png",
                    dpi=(250), bbox_inches='tight')
    else:
        plt.savefig("images/" + str(category) + "_plot_learning_curve_" + datetime.datetime.now().strftime(
            '%s') + ".png",
                    dpi=(250), bbox_inches='tight')
    # plt.show()
