import ffmpeg


def make_animation(input_folder, output_file, input_format="png"):
    (
      ffmpeg
        .input(f'./{input_folder}/*.{input_format}', pattern_type='glob', framerate=30)
        .output(f'./{output_file}', vcodec="mpeg4", video_bitrate='1600k')
        .overwrite_output()
        .run()
    )