import logging

logger_stream = logging.StreamHandler()
logger_stream.setFormatter(logging.Formatter(
    "{asctime}.{msecs:0<3.0f} [{levelname}] {message}", datefmt='%H:%M:%S', style='{'
))
logger = logging.getLogger()
logger.setLevel(logging.INFO)
logger.handlers = [logger_stream]

def info(val, *args, **kwargs) -> None: # pylint: disable=missing-function-docstring
    logging.info(val, *args, **kwargs)