

def set_exp_name(args):
    env = args.env_id.replace("NoFrameskip-v4", "")
    hid = f"_hid{args.hidden_dim}" if args.hidden_dim != 256 else ""
    lin = f"_lin{args.linear_layers}" if args.linear_layers > 0 else ""

    m, b, j, s = "", "", "", ""
    if args.num_ensemble > 1:
        m = f"_m{args.num_ensemble}"
        b = f"tree{args.blocks_in_head}" if args.blocks_in_head != -1 else "full"
        j = f"_tJoint" if args.joint_training else "_tIndep"
        s = f"_sJoint" if args.joint_sampling else "_sIndep"

    den, fix, p_rate, p_decay, freq, grow, prun = "", "", "", "", "", "", ""
    if args.density < 1:
        den = f"_den{str(args.density).replace('.', '_')}"
        fix = "_static" if args.fix else ""
        p_rate = f"_pr{str(args.prune_rate).replace('.', '_')}"
        p_decay = f"_pd-{args.prune_rate_decay}" if args.prune_rate_decay != "constant" else ""
        freq = f"_fq{args.dst_update_freq}"
        grow = f"_{args.growth}" if args.growth != "random" else ""
        prun = f"_{args.prune}" if args.prune != "magnitude" else ""

    return f"{env}_{args.exp_name}{den}{fix}{m}{b}{j}{s}{p_rate}{p_decay}{freq}{grow}{prun}{lin}{hid}_{args.seed}"
