#!/bin/bash

# Define arrays for tau and lr values
tau_values="0.2 0.25 0.3 0.1 0.15"  # Add more values if needed
lr_values="1e-4 5e-4 1e-3 5e-3"   # Add more values if needed
run_id="1 2 3 4 5"
# Loop over tau and lr values
for run_id in $run_id
do
for tau in $tau_values 
    do
    for lr in $lr_values 
        do
        # Execute the Python script with the current values of tau and lr
        python main_VIT_geolora.py --dataset_name cifar10 \
                                     --net_name vit_lora \
                                     --wandb 1 \
                                     --batch_size 256 \
                                     --epochs 20 \
                                     --lr $lr \
                                     --init_r 32 \
                                     --coeff_steps 20 \
                                     --tau $tau
    done
done
done