#!/bin/bash

rm -rf data logs models plots results
mkdir -p logs

BATCH_SIZE=2 # 128 cores
count=0

datasets=("friedman" "diap" "calih")
scenarios=("0" "1" "2")
methods=("subset" "noise")

# Creating models
for dataset in "${datasets[@]}"; do
    python run.py --dataset "$dataset" &>> "logs/${dataset}_0_value.log" &
done
wait

# Calculting reward values
for dataset in "${datasets[@]}"; do 
    for scenario in "${scenarios[@]}"; do
        python run.py \
            --dataset "$dataset" \
            --scenario "$scenario" \
            --method value \
            &>> "logs/${dataset}_${scenario}_value.log" &
    done
done
wait

# Realizing rewards
for dataset in "${datasets[@]}"; do
    for scenario in "${scenarios[@]}"; do
        for method in "${methods[@]}"; do
            python run.py \
                --dataset "$dataset" \
                --scenario "$scenario" \
                --method "$method" \
                &>> "logs/${dataset}_${scenario}_${method}.log" &
            
            ((count++))
            if ((count % BATCH_SIZE == 0)); then
                wait
            fi
        done
    done
done

wait
echo "Finished running all experiments."
