import os
import dill
import yaml
import random 
import torch
import numpy as np

with open('configs.yaml', 'r') as f:
    configs = yaml.safe_load(f)
FILETYPE_CONFIGS = configs['filetype']

def write_file(filedir, filename, content):
    os.makedirs(filedir, exist_ok=True)
    filepath = os.path.join(filedir, f'{filename}.pkl')
    with open(filepath, 'wb') as f:
        dill.dump(content, f)

def read_file(filepath):
    with open(filepath, 'rb') as f:
        return dill.load(f)
    
def read_otherwise_generate(filetype, generator, filename, **kwargs):
    filedir = FILETYPE_CONFIGS[filetype]['directory']
    description = FILETYPE_CONFIGS[filetype]['description']
    filepath = os.path.join(filedir, f'{filename}.pkl')
    if os.path.exists(filepath):
        print(f"{description} {filename} already exists in {filepath}")
        return read_file(filepath)
    print(f"Generating {description} {filename}...")
    content = generator(filename, **kwargs)
    print(f"Finished generating {description} {filename}.")
    write_file(filedir, filename, content)
    return content

def set_seed(seed):
    random.seed(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    torch.backends.cudnn.deterministic = True
    torch.backends.cudnn.benchmark = False