## A Matrix Construction

We begin by generating A matrices with varying entropies, mixing rates, numbers of states, and steady-state distributions with the following script:
```
python construct_A_matrix.py
```
which is going to generate A matrices and save them into ```A_matrix.pickle```.

## Dataset Generation

Next, generate sequences of states and emissions based on the A matrices by running:
```
python generate_dataset.py
```
For each A matrix and each B matrix entropy, number of emissions, and initial state distribution, the script produces 4,096 sequences of length 2,049.

## LLM and Baselines

To evaluate the in-context learning ability of LLMs and other baselines including Baum-Welch (BW), Viterbi, N-gram, and $P(O_t|O_{t-k:t})$, run:
```
python evaluate.py
```
This will save the evaluation results to a pickle file and store the average results across all sequences in a CSV file.

To train and evaluate baseline LSTM, run:
```
python evaluate_lstm.py
```
This will save the evaluation results to a pickle file and store the average results across all sequences in a CSV file.
