# Maximizing Optimized Kernel Dependence
In this repository, we release the code of our proposed method named `Maximizing Optimized Kernel Dependence' which is designed to perform cross-domain few-shot classification via considering maximizing the dependence respectively between representations and labels, and among all representations to learn a set of class-specific representations where the similarities among samples belonging to the same class are maximized while the similarities among samples from different classes are minimized simultaneously.


## Features at a glance
- We follow [URL](https://arxiv.org/pdf/2103.13841.pdf) to train a task-specific linear transformation head on top of a frozen pre-trained multi-domain model during __meta-test__ phase. The backbone can be either a domain-specific backbone that is pre-trained on a specific dataset or a multi-domain backbone that is distilled from several domain-specific backbones.

- In this repo, we provide the code of MOKD based on the [original URL repo](https://github.com/VICO-UoE/URL). 
            

## Model Zoo
- [Single-domain networks (one for each dataset)](https://drive.google.com/file/d/1MvUcvQ8OQtoOk1MIiJmK6_G8p4h8cbY9/view?usp=sharing)

- [A single universal network (URL) learned from 8 training datasets](https://drive.google.com/file/d/1Dv8TX6iQ-BE2NMpfd0sQmH2q4mShmo1A/view?usp=sharing)


## Dependencies
This code requires the following:
* Python 3.6 or greater (Ours: Python 3.8)
* PyTorch 1.0 or greater (Ours: torch=1.7.1, torchvision=0.8.2)
* TensorFlow 1.14 or greater (Ours: TensorFlow=2.10)
* tqdm (Ours: 4.64.1)
* tabulate (0.8.10)

## Installation
* Clone or download this repository.
* Configure Meta-Dataset:
    * Follow the "User instructions" in the [Meta-Dataset repository](https://github.com/google-research/meta-dataset) for "Installation" and "Downloading and converting datasets".
    * To test unseen domain (out-of-domain) performance on additional datasets, i.e. MNIST, CIFAR-10 and CIFAR-100, follow the installation instruction in the [CNAPs repository](https://github.com/cambridge-mlg/cnaps) to get these datasets.


## Maximizing Optimized Kernel Dependence

### Train the Universal Representation Learning Network
1. The easiest way is to download [pre-trained URL model](https://drive.google.com/file/d/1Dv8TX6iQ-BE2NMpfd0sQmH2q4mShmo1A/view?usp=sharing) provided by URL. To download the pretrained URL model, one can use `gdown` (installed by ```pip install gdown```) and execute the following command in the root directory of this project:
    ```
    gdown https://drive.google.com/uc?id=1Dv8TX6iQ-BE2NMpfd0sQmH2q4mShmo1A && md5sum url.zip && unzip url.zip -d ./saved_results/ && rm url.zip
    
    ```
    This will donwnload the URL model and place it in the ```./saved_results``` directory. One can evaluate this model by PA or our MOKD.

2. Alternatively, one can train the model from scratch: 1) train 8 single domain learning networks; 2) train the universal feature extractor as follow. 

#### Train Single Domain Learning Networks
1. The easiest way is to download [pre-trained models](https://drive.google.com/file/d/1MvUcvQ8OQtoOk1MIiJmK6_G8p4h8cbY9/view?usp=sharing) and use them to obtain a universal set of features directly. To download single domain learning networks, execute the following command in the root directory of this project:
    ```
    gdown https://drive.google.com/uc?id=1MvUcvQ8OQtoOk1MIiJmK6_G8p4h8cbY9 && md5sum sdl.zip && unzip sdl.zip -d ./saved_results/ && rm sdl.zip
    ```

    This will download all single domain learning models and place them in the ```./saved_results``` directory of this project.


2. Alternatively, instead of using the pretrained models, one can train the models from scratch.
   To train 8 single domain learning networks, run:
    ```
    ./scripts/train_resnet18_sdl.sh
    ```


#### Train the Universal Feature Extractor
To learn the universal feature extractor by distilling the knowledge from pre-trained single domain learning networks, run: 
```
./scripts/train_resnet18_url.sh
```

### Meta-Testing with MOKD
This step would run Maximizing Optimized Kernel Dependence procedure per task to learn the optimal task-specific parameters for each cross-domain few-shot classification task. Run:
```
./scripts/test_hsic_pa.sh
```

### Meta-Testing with Pre-classifier Alignment (PA)
This step would run Pre-classifier Alignment (PA) procedure per task to adapt the features to a discriminate space and build a Nearest Centroid Classifier (NCC) on the support set to classify query samples, run:

```
./scripts/test_resnet18_pa.sh
```
