import argparse
from pathlib import Path


def parse_opts():
    parser = argparse.ArgumentParser()
    parser.add_argument('--dataset',
                        default='mosi',
                        type=str,
                        help='Used dataset (mosi | mosei | mmimdb | hatememes | food101)')
    parser.add_argument('--stage',
                        default='train_model',
                        type=str,
                        help='Current stage of training (train_model | eval_classifier | eval_dca)')
    parser.add_argument('--root_path',
                        default=None,
                        type=Path,
                        help='Root directory path')
    parser.add_argument('--result_path',
                        default=None,
                        type=Path,
                        help='Result directory path')
    parser.add_argument('--n_classes',
                        default=7,
                        type=int,
                        help=
                        'Number of classes (mosi: 7, mosei: 7, activitynet: 200, kinetics: 400 or 600, ucf101: 101, hmdb51: 51)')
    parser.add_argument('--common_dim',
                        default=60,
                        type=int,
                        help='Common dimension')
    parser.add_argument('--latent_dim',
                        default=60,
                        type=int,
                        help='Common dimension')
    parser.add_argument('--device',
                        default='cuda',
                        type=str,
                        help='Training device')
    parser.add_argument('--learning_rate',
                        default=1e-3,
                        type=float,
                        help=('Initial learning rate'
                              '(divided by 10 while training by lr scheduler)'))
    parser.add_argument('--momentum', default=0.8, type=float, help='Momentum')
    parser.add_argument('--dampening',
                        default=0.0,
                        type=float,
                        help='dampening of SGD')
    parser.add_argument('--weight_decay',
                        default=5e-3,
                        type=float,
                        help='Weight Decay')
    parser.add_argument('--lr_scheduler',
                        default='multistep',
                        type=str,
                        help='Type of LR scheduler (multistep | plateau)')
    parser.add_argument('--train_classifier_only',
                        action='store_true',
                        default=False,
                        help='If true, only train the classifier.')
    parser.add_argument('--batch_size',
                        default=16,
                        type=int,
                        help='Batch Size')
    parser.add_argument('--inference_batch_size',
                        default=8,
                        type=int,
                        help='Batch Size for inference. 0 means this is the same as batch_size.')
    parser.add_argument('--n_epochs',
                        default=200,
                        type=int,
                        help='Number of total epochs to run')
    parser.add_argument('--resume',
                        action='store_true',
                        default=False,
                        help='If true, resume the last ckpt.')
    parser.add_argument('--save_reps',
                        action='store_true',
                        default=False,
                        help='If true, save the reps.')
    parser.add_argument('--transfer_experiment',
                        action='store_true',
                        default=False,
                        help='If true, perform transfer exp mosei -> mosi.')
    parser.add_argument('--manual_seed',
                        default=10,
                        type=int,
                        help='Manually set random seed')
    args = parser.parse_args()

    return args, parser
