#!/bin/bash
if [ -z "$1" ] || [ "$1" -eq "0" ]; then
  echo "TRAINING MODE"
  STATE=train_model
else
  echo "EVAL MODE"
  STATE=eval_classifier
fi

if [ -z "$2" ]; then
  GPU=0
else
  GPU="$2"
fi
echo "GPU: $GPU"
unset TMPDIR

ROOT=./datasets/MOSEI_MOSI
RESULT_ROOT=logs/
DATASET=mosei
N_CLASSES=1

CUDA_VISIBLE_DEVICES=${GPU} python main.py \
  --root_path ${ROOT} \
  --stage ${STATE} \
  --result_path ${RESULT_ROOT} \
  --dataset ${DATASET} --n_classes ${N_CLASSES} \
  --batch_size 256 \
  --lr_scheduler multistep \
  --learning_rate 0.001 --weight_decay 5e-4 \
  --n_epochs=20 \
  # --transfer_experiment
