# Illustrate

This project is based on [Timm](https://github.com/rwightman/pytorch-image-models). The basic operating parameters and environmental requirements are the same as those of [Timm](https://github.com/rwightman/pytorch-image-models). We also give the environmental requirements in the **requirements.txt**.

# Our Experiment Results

*<u>The best results among all backbones are marked with an underline</u>*

We provide three pipelines, pipelines' settings can refer to our paper.



## On ResNet101

| Pipeline | Caltech256-30 | Caltech256-60 | CUB-200 | Stanford Dogs  | MIT Indoor-67 | 
| :---: | :---: | :---: | :---: | :---: | :---: | 
| Pipeline I  | 83.43% | 86.36% | 83.94% | <u>**92.33%**</u> | 80.22% | 
| Pipeline II | 83.02% | 85.27% | <u>**84.89%**</u> | 91.75% | <u>**80.52%**</u>| 
| Pipeline I+ | <u>**86.62%**</u> | <u>**86.66%**</u> | - | - | - | 


## On ResNet50

| Pipeline | Caltech256-30 | Caltech256-60 | CUB-200 | Stanford Dogs  | MIT Indoor-67 | 
| :---: | :---: | :---: | :---: | :---: | :---: | 
| Pipeline I  | 80.58% | 83.39% | **83.98%** | 90.50% | 79.4% | 
| Pipeline II | 81.09% | 83.73% | 83.93% | **90.92%** | **79.62%** | 
| Pipeline I+ | **83.32%**| **83.96%**| - | - | - | 

## On VGG-16

| Pipeline | Caltech256-30 | Caltech256-60 | CUB-200 | Stanford Dogs  | MIT Indoor-67 | 
| :---: | :---: | :---: | :---: | :---: | :---: | 
| Pipeline I   | 52.61% | 58.47% | 76.51% | 75.81% | 72.23% | 
| Pipeline II  | 60.46% | 66.42% | **80.3%**|**77.65%** | **75.59%** | 
| Pipeline III | **66.46%** | **70.66%**| 64.84% | 83.39% | 71.34% | 
| Pipeline I+  | 63.37% | 66.28% | - | - | - | 

# Evaluation

We provide best [models]() under three pipelines, [datasets](https://drive.google.com/file/d/1vdL11PF8KBqdW0oBs5NvC3BXF4Hv1shj/view?usp=sharing) are also provided, click to download, and unzip them in the corresponding (**output** and **data**) files.

| Backbone | Pipeline | DataSet | Script |
| :---: | :---: | :---: | :---: | 
| ResNet101 | Pipeline I+  | Caltech256-30 | ./script/best_on_Caltech256_30.sh | 
| ResNet101 | Pipeline I+ | Caltech256-60 | ./script/best_on_Caltech256_60.sh| 
| ResNet101 | Pipeline II | CUB-200 | ./script/best_on_CUB_200.sh | 
| ResNet101 | Pipeline I | Stanford Dogs | ./script/best_on_MIT67.sh | 
| ResNet101 | Pipeline II | MIT Indoor-67 | ./script/best_on_StanfordDogs.sh |

 We provide running parameters for evaluation in **script** file. After unziping you can simply run the script in the table above to get the corresponding evaluation result.

# Training

If you want to start training from an ImageNet pre-trained model instead of testing the model we provide, you can refer to the four settings

## Fine tuning

```
python train.py ./data --dataset <five-available-datasets> --dataset-download --model <backbone> -b <batch-size> --amp --num-classes <corresponding-number> --num_clusters <corresponding-number> \
--opt adamw --lr 3e-4 --weight-decay .005 --pretrained -j 2 \
--output <output-directory> --experiment <experiment-name> --checkpoint-hist <save-top-n-model> 

```

## Pipeline 1

```
python train_kt.py ./data --dataset <five-available-datasets> --dataset-download --model <backbone> -b <batch-size> --amp --num-classes <corresponding-number> --num_clusters <corresponding-number> \
--opt adamw --lr 3e-4 --weight-decay .005 --pretrained --use_compensate -j 2 \
--output <output-directory> --experiment <experiment-name> \
--resume <the-fine-tuned-best-model-directory> --checkpoint-hist <save-top-n-model> 

```
If you wish to use **Pipeline 1** on **VGG-16**, please switch the training process to **train_vgg16.py**

## Pipeline 2

```
python train.py ./data --dataset <five-available-datasets> --dataset-download --model <backbone> -b <batch-size> --amp --num-classes <corresponding-number> --num_clusters <corresponding-number> \
--opt adamw --lr 3e-4 --weight-decay .005 --pretrained -j 2 --use_compensate \
--output <output-directory> --experiment <experiment-name> --checkpoint-hist <save-top-n-model>

```

## Pipeline 3

**Pipeline 3** is only for **VGG-16**. Please use it with caution.

```
python train_vgg16.py ./data --dataset <five-available-datasets> --dataset-download --model vgg16  -b <batch-size>  --amp --num-classes <corresponding-number> --num_clusters <corresponding-number> \
--opt adamw --lr 3e-4 --weight-decay .005 --pretrained -j 2 --use_compensate \
--output <output-directory>--experiment <experiment-name> --checkpoint-hist <save-top-n-model>

```

## Optional Parameters

###  Available datasets and Corresponding parameters

| --dataset | --num-classes | --num_clusters |
| :---: | :---: | :---: | :---: |
| torch/Caltech256-30 | 256  | 256 |
| torch/Caltech256-30 | 256 | 256 |
| torch/cub-200 | 200 | 200 |
| torch/Stanford-Dogs | 120 | 120 |
| torch/MIT67 | 67 | 67|

### Backbone

| --model |
| :---: |
| resnet101 |
| resnet50 |
| vgg16 |
