# summarizing plot
import pandas as pd

# Load the new dataset where sigma varies
df_sigmas_updated = pd.read_csv("output/cix_sigmas_test_errors_mean_std.csv")
# Remove entries corresponding to the WGAN loss function from the sigma dataset
df_sigmas_no_wgan = df_sigmas_updated[df_sigmas_updated['loss_function'] != 'WGAN']

# List unique loss functions present in the dataframe
unique_loss_functions = df_sigmas_updated['loss_function'].unique()
unique_loss_functions
import matplotlib.pyplot as plt
import seaborn as sns
from mpl_toolkits.axes_grid1.inset_locator import inset_axes
# Set plot style and define distinct markers and colors
# Set plot style and define distinct markers and colors
sns.set_style("whitegrid")

# Set plot style and define distinct markers and colors
plt.figure(figsize=(12, 10))
markers = ['o', 's', '^', 'D', '*', 'p', 'v', '<', '>']
colors = sns.color_palette("tab10", len(df_sigmas_no_wgan['loss_function'].unique()))

# Plot for mse_f_mean without WGAN
plt.subplot(2, 1, 1)
for idx, loss_func in enumerate(df_sigmas_no_wgan['loss_function'].unique()):
    subset = df_sigmas_no_wgan[df_sigmas_no_wgan['loss_function'] == loss_func]
    plt.plot(subset['σ'], subset['mse_f_mean'], label=loss_func, 
             marker=markers[idx], color=colors[idx], markersize=6, linestyle='-')
    plt.fill_between(subset['σ'], 
                     subset['mse_f_mean'] - subset['mse_f_std'], 
                     subset['mse_f_mean'] + subset['mse_f_std'], color=colors[idx], alpha=0.2)
plt.title('Comparison of Deterministic Driving Force Errors Without WGAN')
plt.xlabel('σ (Sigma Value)')
plt.ylabel('Mean Error in Deterministic Driving Force (mse_f)')
plt.legend()

# Plot for mse_σ_mean without WGAN and create inset in the upper left
plt.subplot(2, 1, 2)
for idx, loss_func in enumerate(df_sigmas_no_wgan['loss_function'].unique()):
    subset = df_sigmas_no_wgan[df_sigmas_no_wgan['loss_function'] == loss_func]
    plt.plot(subset['σ'], subset['mse_σ_mean'], label=loss_func, 
             marker=markers[idx], color=colors[idx], markersize=6, linestyle='-')
    plt.fill_between(subset['σ'], 
                     subset['mse_σ_mean'] - subset['mse_σ_std'], 
                     subset['mse_σ_mean'] + subset['mse_σ_std'], color=colors[idx], alpha=0.2)

plt.title('Comparison of Diffusion Errors Without WGAN')
plt.xlabel('σ (Sigma Value)')
plt.ylabel('Mean Error in Diffusion (mse_σ)')
plt.legend()

# Inset plot with y-log scale in the upper left
axins = inset_axes(plt.gca(), width="30%", height="30%", loc='upper left',borderpad=10)
for idx, loss_func in enumerate(df_sigmas_no_wgan['loss_function'].unique()):
    subset = df_sigmas_no_wgan[df_sigmas_no_wgan['loss_function'] == loss_func]
    axins.plot(subset['σ'], subset['mse_σ_mean'],
               marker=markers[idx], color=colors[idx], markersize=4, linestyle='-')
    axins.fill_between(subset['σ'], 
                     subset['mse_σ_mean'] - subset['mse_σ_std'], 
                     subset['mse_σ_mean'] + subset['mse_σ_std'], color=colors[idx], alpha=0.2)
axins.set_yscale('log')

plt.tight_layout()
plt.savefig("output/plot_comparison_sigmas_no_wgan_inset_upper_left.svg", format="svg")
plt.savefig("output/plot_comparison_sigmas_no_wgan_inset_upper_left.png", format="svg")

plt.savefig("output/plot_comparison_sigmas_no_wgan_inset_upper_left.pdf", format="pdf")
plt.show()
