using Distributed 
addprocs(16)
@everywhere using ProgressMeter

@everywhere function run_profile(info)
    profile, loss_function, repeat = info
    (run∘pipeline)(`python cix_base.py --profile $profile --loss_function $loss_function --repeat $repeat`)
end

profiles1 = [
   "n_sample_50",
   "n_sample_100",
   "n_sample_200",
   "n_sample_400",
]

# profiles2 = [
#     "sigma_$(replace("$i", "." => "_"))" for i in 0.0:0.1:1.0
# ]

# # concat the two profiles
# profiles = vcat(profiles1, profiles2)

# profiles_delta = [
#     "delta_$(replace("$i", "." => "_"))" for i in 0.0:0.1:1.0
# ]

# profiles_width =[
#     "width_$(replace("$i", "." => "_"))" for i in [16, 32, 64, 128]
# ]

# profiles_resnet_layers =[
#     "resnet_layers_$(replace("$i", "." => "_"))" for i in [2,3,4,5]
# ]

# profiles_layer =[
#     "layers_$(replace("$i", "." => "_"))" for i in [2,3,4,5]
# ]

profiles = profiles1
loss_functions = [
     "W2",
    #  "apprx_loglik",
    # "WGAN",
    #  "MMD",
#    "W1",
    # "mse",
    #  "mean2_var",
]

repeats = 1:10
    
infos = [
    (profile, loss_function, repeat) for profile in profiles, 
    loss_function in loss_functions, 
    repeat in repeats
]


@info "The following profiles will be executed:" infos

try
    # for profile in profiles
    #     @show profile
    #     run_profile(profile)
    # end
    progress_pmap(run_profile, 
    infos; progress = Progress(length(infos), color=:green, showspeed = true,barglyphs=BarGlyphs("[=> ]")))
    # @time pmap(run_profile, profiles)
    # the content of mail_success is 
catch e
end

