# Code for the paper "Applying Wasserstein-2 Distance for Efficient Reconstruction of Stochastic Differential Equations"

The code is organized in two parts, for Example 1, 
Flux.jl is used to define and train the neural network; for the other examples, we used PyTorch.

## Example 1
Run `julia src/nsde_ground_truth.jl` to generate the ground truth data.
Run `julia src/nsde_(loss).jl` to train the neural network with different loss functions. Replace (loss) with avg_std, log_likelihood, mse, w2.

## Example 2
Run `python cix_base.py --profile (profile) --loss_function (loss)` to generate data and train the neural network. Profiles are defined under the directory `profiles`. Undefined profile will be default to `base` profiles. 

Used profiles and batch parallel training can be found in `cix_worker.jl`


## Example 3
Similarly, 
Run `python temporal_OU_base.py --profile (profile) --loss_function (loss)` to generate data and train the neural network. Profiles are defined under the directory `profiles`. Undefined profile will be default to `base` profiles.

Used profiles and batch parallel training can be found in `temporal_OU_worker.jl`

For WGAN training, a dedicated `temporal_OU_wgan_ncde_base.py` is used.

## Example 4
Run `python example2d_base.py --profile (profile) --loss_function (loss)` to generate data and train the neural network. Profiles are defined under the directory `profiles`. Undefined profile will be default to `base` profiles.

Used profiles and batch parallel training can be found in `example2d_worker.jl`
