using Distributed
addprocs(11)

@everywhere include("sde_batching_utils.jl")

@everywhere using ProgressMeter

using ArgParse

# check if contains test flag
# defaults to false, i.e. training
s = ArgParseSettings()
@add_arg_table! s begin
    "--test"
        help = "test flag"
        action = :store_true
end

args = ArgParse.parse_args(ARGS, s)
flag_test = args["test"]

if flag_test
    @info "Testing mode"
else
    @info "Training mode"
end

ps = [ [0.5, i] for i in 0.0:0.1:2.0 ]


try
    progress_pmap(p_id -> evaluate(p_id[1], p_id[2]; test = flag_test), [(p, i) for (i, p) in enumerate(ps)]; 
                    progress=Progress(length(ps);
                                dt = 1, 
                                desc="evaluating", 
                                color=:green, 
                                showspeed=true)
        )
        mail_body = """
        From: "Automata" <automata@ryzen>
        To: "Xiangting Li" <xiangting.li@ucla.edu>
        Subject: wasserstein simulation task completed
    
        Hi Xiangting,
    
        The tasks scheduled in wasserstein simulation are completed.
    
        Please check the result.
        Automata.
        """
        open("mail_success.txt", "w") do f
            write(f, mail_body)
        end
        run(pipeline(`ssmtp xiangting.li@ucla.edu`; stdin = "mail_success.txt"))
        # remove the mail_success
        rm("mail_success.txt")
catch e
    mail_body = """
    From: "Automata" <automata@ryzen>
    To: "Xiangting Li" <xiangting.li@ucla.edu>
    Subject: wasserstein simulation task failed

    Hi Xiangting,

    The tasks scheduled in wasserstein simulation encountered a problem. Please review the logs and fix the problem.
    $(e)
    The profiles are:
        - $(join(profiles, "\n     -"))
    
    Automata.
    """
    open("mail_failure.txt", "w") do f
        write(f, mail_body)
    end
    run(pipeline(`ssmtp xiangting.li@ucla.edu`; stdin = "mail_failure.txt"))
    # remove the mail_failure
    rm("mail_failure.txt")
end
